
local assets=
{
	Asset("ANIM", "anim/drop_aoruisword.zip"),
    Asset("ANIM", "anim/aoruisword.zip"), 
    Asset("ATLAS", "images/inventoryimages/aoruisword.xml"),
}

local prefabs = 
{
}
local function onfinished(inst)
  inst:Remove()
end
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "aoruisword", "aoruisword")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

	end


local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
local function fn()
local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("drop_aoruisword")
    inst.AnimState:SetBuild("drop_aoruisword")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "aoruisword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aoruisword.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
    
	inst:AddComponent("inspectable")
    inst.components.weapon:SetDamage(45)
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(16)
	inst.components.finiteuses:SetUses(16)
	inst.components.finiteuses:SetOnFinished(onfinished)
    return inst
end
return Prefab("aoruisword", fn, assets)